(***********************************************************************

                    Mathematica-Compatible Notebook

This notebook can be used on any computer system with Mathematica 3.0,
MathReader 3.0, or any compatible application. The data for the notebook 
starts with the line of stars above.

To get the notebook into a Mathematica-compatible application, do one of 
the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing the 
word CacheID, otherwise Mathematica-compatible applications may try to 
use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
***********************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[     16970,        649]*)
(*NotebookOutlinePosition[     17810,        676]*)
(*  CellTagsIndexPosition[     17766,        672]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell["Style Definitions", "Subtitle"],

Cell["\<\
Modify the definitions below to change the default appearance of \
all cells in a given style.
Make modifications to any definition using commands in the Format menu.\
\>", 
  "Text"],

Cell[CellGroupData[{

Cell["Style Environment Names", "Section"],

Cell[StyleData[All, "Working"],
  ScriptMinSize->9],

Cell[StyleData[All, "Printout"],
  PageWidth->PaperWidth,
  ShowCellLabel->False,
  CellFrameLabelMargins->6,
  ImageSize->{200, 200},
  PrivateFontOptions->{"FontType"->"Outline"}]
}, Closed]],

Cell[CellGroupData[{

Cell["Notebook Options", "Section"],

Cell["\<\
The options defined for the style below will be used at the \
Notebook level.\
\>", "Text"],

Cell[StyleData["Notebook"],
  PageHeaders->{{Cell[ 
          TextData[ {
            CounterBox[ "Page"]}], "PageNumber"], None, Cell[ 
          TextData[ {
            ValueBox[ "FileName"]}], "Header"]}, {Cell[ 
          TextData[ {
            ValueBox[ "FileName"]}], "Header"], None, Cell[ 
          TextData[ {
            CounterBox[ "Page"]}], "PageNumber"]}},
  PageHeaderLines->{True, True},
  PrintingOptions->{"FirstPageHeader"->False,
  "FacingPages"->True},
  CellLabelAutoDelete->False,
  CellFrameLabelMargins->6,
  StyleMenuListing->None]
}, Closed]],

Cell[CellGroupData[{

Cell["Styles for Headings", "Section"],

Cell[CellGroupData[{

Cell[StyleData["Title"],
  CellFrame->{{0, 0}, {0, 0.5}},
  CellMargins->{{18, 10}, {4, 20}},
  CellGroupingRules->{"TitleGrouping", 0},
  PageBreakBelow->False,
  CellFrameMargins->9,
  LineSpacing->{0.95, 0},
  CounterIncrements->"Title",
  CounterAssignments->{{"Section", 0}, {"Equation", 0}, {"Figure", 0}},
  FontFamily->"Helvetica",
  FontSize->36,
  FontWeight->"Bold"],

Cell[StyleData["Title", "Printout"],
  CellMargins->{{18, 4}, {0, 0}},
  CellFrameMargins->4,
  FontSize->24]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["Subtitle"],
  CellMargins->{{18, 10}, {0, 10}},
  CellGroupingRules->{"TitleGrouping", 10},
  PageBreakBelow->False,
  LineSpacing->{1, 0},
  CounterIncrements->"Subtitle",
  CounterAssignments->{{"Section", 0}, {"Equation", 0}, {"Figure", 0}},
  FontFamily->"Helvetica",
  FontSize->24],

Cell[StyleData["Subtitle", "Printout"],
  FontSize->18]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["SectionFirst"],
  CellFrame->{{0, 0}, {0, 3}},
  CellMargins->{{18, 10}, {10, 30}},
  CellGroupingRules->{"SectionGrouping", 40},
  PageBreakBelow->False,
  CellFrameMargins->5,
  CounterIncrements->"Section",
  CounterAssignments->{{"Subsection", 0}, {"Subsubsection", 0}},
  FontFamily->"Helvetica",
  FontSize->18,
  FontWeight->"Bold"],

Cell[StyleData["SectionFirst", "Printout"],
  CellMargins->{{18, 4}, {10, 30}},
  FontSize->14]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["Section"],
  CellMargins->{{18, 10}, {10, 30}},
  CellGroupingRules->{"SectionGrouping", 40},
  PageBreakBelow->False,
  CounterIncrements->"Section",
  CounterAssignments->{{"Subsection", 0}, {"Subsubsection", 0}},
  FontFamily->"Helvetica",
  FontSize->18,
  FontWeight->"Bold"],

Cell[StyleData["Section", "Printout"],
  CellMargins->{{18, 4}, {10, 30}},
  FontSize->14]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["Subsection"],
  CellDingbat->"\[FilledSquare]",
  CellMargins->{{18, 50}, {10, 26}},
  CellGroupingRules->{"SectionGrouping", 50},
  PageBreakBelow->False,
  CounterIncrements->"Subsection",
  CounterAssignments->{{"Subsubsection", 0}},
  FontFamily->"Helvetica",
  FontSize->14,
  FontWeight->"Bold"],

Cell[StyleData["Subsection", "Printout"],
  FontSize->12]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["Subsubsection"],
  CellDingbat->"\[FilledSmallSquare]",
  CellMargins->{{18, 50}, {6, 20}},
  CellGroupingRules->{"SectionGrouping", 60},
  PageBreakBelow->False,
  CounterIncrements->"Subsubsection",
  FontFamily->"Helvetica",
  FontSize->12,
  FontWeight->"Bold"],

Cell[StyleData["Subsubsection", "Printout"],
  FontSize->10]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Styles for Body Text", "Section"],

Cell[CellGroupData[{

Cell[StyleData["Text"],
  CellMargins->{{18, 10}, {Inherited, 4}},
  TextJustification->1,
  LineSpacing->{1, 3},
  CounterIncrements->"Text"],

Cell[StyleData["Text", "Printout"],
  CellMargins->{{18, 4}, {Inherited, 0}},
  LineSpacing->{1, 3},
  FontSize->10]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["Caption"],
  CellMargins->{{55, 55}, {5, 4}},
  PageBreakAbove->False,
  FontFamily->"Helvetica",
  FontSize->9],

Cell[StyleData["Caption", "Printout"],
  FontSize->8]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Styles for Input/Output", "Section"],

Cell["\<\
The cells in this section define styles used for input and output \
to the kernel.  Be careful when modifying, renaming, or removing these \
styles, because the front end associates special meanings with these style \
names.\
\>", "Text"],

Cell[CellGroupData[{

Cell[StyleData["Input"],
  CellFrame->{{1, 1}, {0, 1}},
  CellMargins->{{55, 10}, {0, 10}},
  Evaluatable->True,
  CellGroupingRules->"InputGrouping",
  CellHorizontalScrolling->True,
  PageBreakWithin->False,
  GroupPageBreakWithin->False,
  CellLabelMargins->{{23, Inherited}, {Inherited, Inherited}},
  DefaultFormatType->DefaultInputFormatType,
  AutoItalicWords->{},
  FormatType->InputForm,
  ShowStringCharacters->True,
  NumberMarks->True,
  CounterIncrements->"Input",
  FontWeight->"Bold",
  Background->GrayLevel[0.850004]],

Cell[StyleData["Input", "Printout"],
  CellMargins->{{55, 55}, {0, 10}},
  ShowCellLabel->False,
  FontSize->10]
}, Closed]],

Cell[StyleData["InlineInput"],
  Evaluatable->True,
  CellGroupingRules->"InputGrouping",
  CellHorizontalScrolling->True,
  PageBreakWithin->False,
  GroupPageBreakWithin->False,
  DefaultFormatType->DefaultInputFormatType,
  AutoItalicWords->{},
  FormatType->InputForm,
  ShowStringCharacters->True,
  NumberMarks->True,
  CounterIncrements->"Input",
  FontWeight->"Bold"],

Cell[CellGroupData[{

Cell[StyleData["Output"],
  CellFrame->{{1, 1}, {1, 0}},
  CellMargins->{{55, 10}, {10, 0}},
  CellEditDuplicate->True,
  CellGroupingRules->"OutputGrouping",
  CellHorizontalScrolling->True,
  PageBreakWithin->False,
  GroupPageBreakWithin->False,
  GeneratedCell->True,
  CellAutoOverwrite->True,
  CellLabelMargins->{{23, Inherited}, {Inherited, Inherited}},
  DefaultFormatType->DefaultOutputFormatType,
  AutoItalicWords->{},
  FormatType->InputForm,
  CounterIncrements->"Output",
  Background->GrayLevel[0.850004]],

Cell[StyleData["Output", "Printout"],
  CellMargins->{{55, 55}, {10, 0}},
  ShowCellLabel->False,
  FontSize->10]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["InputOnly"],
  CellFrame->1,
  CellMargins->{{55, 10}, {0, 10}},
  Evaluatable->True,
  CellGroupingRules->"InputGrouping",
  CellHorizontalScrolling->True,
  PageBreakWithin->False,
  GroupPageBreakWithin->False,
  CellLabelMargins->{{23, Inherited}, {Inherited, Inherited}},
  DefaultFormatType->DefaultInputFormatType,
  AutoItalicWords->{},
  FormatType->InputForm,
  ShowStringCharacters->True,
  NumberMarks->True,
  CounterIncrements->"Input",
  FontWeight->"Bold",
  Background->GrayLevel[0.850004]],

Cell[StyleData["InputOnly", "Printout"],
  CellMargins->{{55, 55}, {0, 10}},
  ShowCellLabel->False,
  FontSize->10]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["Message"],
  CellFrame->{{1, 1}, {0, 0}},
  CellDingbat->"\[LongDash]",
  CellMargins->{{55, 10}, {0, 0}},
  CellGroupingRules->"OutputGrouping",
  PageBreakWithin->False,
  GroupPageBreakWithin->False,
  GeneratedCell->True,
  CellAutoOverwrite->True,
  ShowCellLabel->False,
  CellLabelMargins->{{23, Inherited}, {Inherited, Inherited}},
  DefaultFormatType->DefaultOutputFormatType,
  AutoItalicWords->{},
  FormatType->InputForm,
  CounterIncrements->"Message",
  StyleMenuListing->None,
  FontFamily->"Helvetica",
  FontSize->10,
  FontSlant->"Oblique"],

Cell[StyleData["Message", "Printout"],
  CellMargins->{{55, 55}, {0, 0}},
  FontSize->8]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["Print"],
  CellMargins->{{55, 26}, {1, 6}},
  CellGroupingRules->"OutputGrouping",
  CellHorizontalScrolling->True,
  PageBreakWithin->False,
  GroupPageBreakWithin->False,
  GeneratedCell->True,
  CellAutoOverwrite->True,
  ShowCellLabel->False,
  CellLabelMargins->{{23, Inherited}, {Inherited, Inherited}},
  DefaultFormatType->DefaultOutputFormatType,
  TextAlignment->Left,
  AutoItalicWords->{},
  FormatType->InputForm,
  CounterIncrements->"Print",
  StyleMenuListing->None,
  Background->GrayLevel[0.700008]],

Cell[StyleData["Print", "Printout"],
  CellMargins->{{54, 72}, {2, 6}},
  FontSize->10]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["Graphics"],
  CellFrame->{{1, 1}, {0, 0}},
  CellMargins->{{55, 10}, {0, 0}},
  CellGroupingRules->"GraphicsGrouping",
  CellHorizontalScrolling->True,
  PageBreakWithin->False,
  GeneratedCell->True,
  CellAutoOverwrite->True,
  ShowCellLabel->False,
  DefaultFormatType->DefaultOutputFormatType,
  FormatType->InputForm,
  CounterIncrements->"Graphics",
  ImageMargins->{{35, Inherited}, {Inherited, 0}},
  StyleMenuListing->None,
  Background->GrayLevel[0.850004]],

Cell[StyleData["Graphics", "Printout"],
  CellMargins->{{55, 55}, {0, 0}},
  ImageSize->{0.0625, 0.0625}]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["CellLabel"],
  StyleMenuListing->None,
  FontFamily->"Helvetica",
  FontSize->9,
  FontSlant->"Oblique"],

Cell[StyleData["CellLabel", "Printout"],
  CellMargins->{{0, Inherited}, {Inherited, Inherited}},
  FontSize->8]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Unique Styles", "Section"],

Cell[CellGroupData[{

Cell[StyleData["Author"],
  CellMargins->{{20, Inherited}, {2, 20}},
  CellGroupingRules->{"TitleGrouping", 20},
  PageBreakBelow->False,
  CounterAssignments->{{"Section", 0}, {"Equation", 0}, {"Figure", 0}},
  FontFamily->"Helvetica",
  FontSize->14,
  FontSlant->"Italic"],

Cell[StyleData["Author", "Printout"],
  CellMargins->{{36, Inherited}, {2, 30}},
  FontSize->12]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["Address"],
  CellMargins->{{18, Inherited}, {2, 2}},
  CellGroupingRules->{"TitleGrouping", 30},
  PageBreakBelow->False,
  LineSpacing->{1, 1},
  CounterAssignments->{{"Section", 0}, {"Equation", 0}, {"Figure", 0}},
  FontFamily->"Helvetica",
  FontSlant->"Italic"],

Cell[StyleData["Address", "Printout"],
  CellMargins->{{36, Inherited}, {2, 2}},
  FontSize->10]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["Abstract"],
  CellFrame->False,
  CellMargins->{{45, 75}, {Inherited, 30}},
  LineSpacing->{1, 1}],

Cell[StyleData["Abstract", "Printout"],
  CellMargins->{{36, 67}, {Inherited, 50}},
  FontSize->10]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["Reference"],
  CellMargins->{{18, 40}, {Inherited, 0}},
  TextJustification->1,
  LineSpacing->{1, 0}],

Cell[StyleData["Reference", "Printout"],
  FontSize->8]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["PictureGroup"],
  CellFrame->{{1, 1}, {0, 0}},
  CellMargins->{{55, Inherited}, {0, 0}},
  CellGroupingRules->"GraphicsGrouping",
  CellHorizontalScrolling->True,
  PageBreakWithin->False,
  ShowCellLabel->False,
  CounterIncrements->"Graphics",
  ImageMargins->{{35, Inherited}, {Inherited, 0}},
  StyleMenuListing->None,
  Background->GrayLevel[0.850004]],

Cell[StyleData["PictureGroup", "Printout"],
  CellMargins->{{55, Inherited}, {0, 0}},
  ImageSize->{0.0625, 0.0625}]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Styles for Automatic Numbering", "Section"],

Cell["\<\
The following styles are useful for numbered equations, figures, \
etc.  They automatically give the cell a FrameLabel containing a reference to \
a particular counter, and also increment that counter.\
\>", "Text"],

Cell[CellGroupData[{

Cell[StyleData["NumberedEquation"],
  CellMargins->{{55, 10}, {2, 10}},
  CellFrameLabels->{{None, Cell[ 
          TextData[ {"(", 
            CounterBox[ "NumberedEquation"], ")"}], FontFamily -> "Helvetica",
           FontSize -> 10, FontWeight -> "Bold"]}, {None, None}},
  DefaultFormatType->DefaultInputFormatType,
  CounterIncrements->"NumberedEquation",
  FormatTypeAutoConvert->False],

Cell[StyleData["NumberedEquation", "Printout"],
  CellFrameLabels->{{None, Cell[ 
          TextData[ {"(", 
            CounterBox[ "NumberedEquation"], ")"}], FontFamily -> "Helvetica",
           FontSize -> 8, FontWeight -> "Bold"]}, {None, None}}]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["NumberedFigure"],
  CellMargins->{{55, 145}, {2, 10}},
  CellFrameLabels->{{None, None}, {Cell[ 
          TextData[ {"Figure ", 
            CounterBox[ "NumberedFigure"]}], FontFamily -> "Helvetica", 
          FontSize -> 10, FontWeight -> "Bold"], None}},
  TextAlignment->Left,
  CounterIncrements->"NumberedFigure",
  FormatTypeAutoConvert->False],

Cell[StyleData["NumberedFigure", "Printout"],
  CellFrameLabels->{{None, None}, {Cell[ 
          TextData[ {"Figure ", 
            CounterBox[ "NumberedFigure"]}], FontFamily -> "Helvetica", 
          FontSize -> 8, FontWeight -> "Bold"], None}}]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["NumberedTable"],
  CellMargins->{{55, 145}, {2, 10}},
  CellFrameLabels->{{None, None}, {Cell[ 
          TextData[ {"Table ", 
            CounterBox[ "NumberedTable"]}], FontFamily -> "Helvetica", 
          FontSize -> 10, FontWeight -> "Bold"], None}},
  TextAlignment->Center,
  CounterIncrements->"NumberedTable",
  FormatTypeAutoConvert->False],

Cell[StyleData["NumberedTable", "Printout"],
  CellFrameLabels->{{None, None}, {Cell[ 
          TextData[ {"Table ", 
            CounterBox[ "NumberedTable"]}], FontFamily -> "Helvetica", 
          FontSize -> 8, FontWeight -> "Bold"], None}}]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Formulas and Programming", "Section"],

Cell[CellGroupData[{

Cell[StyleData["DisplayFormula"],
  CellMargins->{{55, 10}, {2, 10}},
  CellHorizontalScrolling->True,
  DefaultFormatType->DefaultInputFormatType,
  ScriptLevel->0,
  SingleLetterItalics->True,
  UnderoverscriptBoxOptions->{LimitsPositioning->True}],

Cell[StyleData["DisplayFormula", "Printout"],
  FontSize->10]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["ChemicalFormula"],
  CellMargins->{{55, 10}, {2, 10}},
  DefaultFormatType->DefaultInputFormatType,
  AutoSpacing->False,
  ScriptLevel->1,
  ScriptBaselineShifts->{0.6, Automatic},
  SingleLetterItalics->False,
  ZeroWidthTimes->True],

Cell[StyleData["ChemicalFormula", "Printout"],
  FontSize->10]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["Program"],
  CellMargins->{{18, 10}, {Inherited, 6}},
  FontFamily->"Courier"],

Cell[StyleData["Program", "Printout"],
  CellMargins->{{18, 30}, {Inherited, 4}},
  FontSize->9.5]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Styles for Headers and Footers", "Section"],

Cell[StyleData["Header"],
  StyleMenuListing->None,
  FontFamily->"Helvetica",
  FontSize->9],

Cell[StyleData["PageNumber"],
  StyleMenuListing->None,
  FontFamily->"Helvetica",
  FontSize->9,
  FontWeight->"Bold"],

Cell[StyleData["Footer"],
  StyleMenuListing->None,
  FontFamily->"Helvetica",
  FontSize->7]
}, Closed]]
}, Open  ]]
},
FrontEndVersion->"Macintosh 3.0",
ScreenRectangle->{{0, 1024}, {0, 748}},
WindowSize->{474, 298},
WindowMargins->{{12, Automatic}, {Automatic, 7}},
MacintoshSystemPageSetup->"\<\
00<0001804P000000]P2:?oQon82n@960dL5:0?l0080001804P000000]P2:001
0000I00000400`<300000BL?00400@00000000000000060801T1T00000000000
00000000000000000000000000000000\>"
]


(***********************************************************************
Cached data follows.  If you edit this Notebook file directly, not using
Mathematica, you must remove the line containing CacheID at the top of 
the file.  The cache data will then be recreated when you save this file 
from within Mathematica.
***********************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{

Cell[CellGroupData[{
Cell[1731, 51, 37, 0, 52, "Subtitle"],
Cell[1771, 53, 193, 5, 62, "Text"],

Cell[CellGroupData[{
Cell[1989, 62, 42, 0, 50, "Section"],
Cell[2034, 64, 51, 1, 36, 31, 0, "StyleData", "All", "Working"],
Cell[2088, 67, 181, 5, 36, 32, 0, "StyleData", "All", "Printout"]
}, Closed]],

Cell[CellGroupData[{
Cell[2306, 77, 35, 0, 30, "Section"],
Cell[2344, 79, 101, 3, 30, "Text"],
Cell[2448, 84, 559, 15, 36, 27, 0, "StyleData", "Notebook", "All",
  StyleMenuListing->None]
}, Closed]],

Cell[CellGroupData[{
Cell[3044, 104, 38, 0, 30, "Section"],

Cell[CellGroupData[{
Cell[3107, 108, 377, 11, 85, 24, 0, "StyleData", "Title", "All",
  CounterIncrements->"Title",
  CounterAssignments->{{"Section", 0}, {"Equation", 0}, {"Figure", 0}}],
Cell[3487, 121, 109, 3, 45, 36, 0, "StyleData", "Title", "Printout"]
}, Closed]],

Cell[CellGroupData[{
Cell[3633, 129, 303, 8, 53, 27, 0, "StyleData", "Subtitle", "All",
  CounterIncrements->"Subtitle",
  CounterAssignments->{{"Section", 0}, {"Equation", 0}, {"Figure", 0}}],
Cell[3939, 139, 55, 1, 44, 39, 0, "StyleData", "Subtitle", "Printout"]
}, Closed]],

Cell[CellGroupData[{
Cell[4031, 145, 355, 10, 64, 31, 0, "StyleData", "SectionFirst", "All",
  CounterIncrements->"Section",
  CounterAssignments->{{"Subsection", 0}, {"Subsubsection", 0}}],
Cell[4389, 157, 95, 2, 78, 43, 0, "StyleData", "SectionFirst", "Printout"]
}, Closed]],

Cell[CellGroupData[{
Cell[4521, 164, 296, 8, 56, 26, 0, "StyleData", "Section", "All",
  CounterIncrements->"Section",
  CounterAssignments->{{"Subsection", 0}, {"Subsubsection", 0}}],
Cell[4820, 174, 90, 2, 70, 38, 0, "StyleData", "Section", "Printout"]
}, Closed]],

Cell[CellGroupData[{
Cell[4947, 181, 317, 9, 52, 29, 0, "StyleData", "Subsection", "All",
  CounterIncrements->"Subsection",
  CounterAssignments->{{"Subsubsection", 0}}],
Cell[5267, 192, 57, 1, 65, 41, 0, "StyleData", "Subsection", "Printout"]
}, Closed]],

Cell[CellGroupData[{
Cell[5361, 198, 281, 8, 47, 32, 0, "StyleData", "Subsubsection", "All",
  CounterIncrements->"Subsubsection"],
Cell[5645, 208, 60, 1, 53, 44, 0, "StyleData", "Subsubsection", "Printout"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[5754, 215, 39, 0, 30, "Section"],

Cell[CellGroupData[{
Cell[5818, 219, 142, 4, 36, 23, 0, "StyleData", "Text", "All",
  CounterIncrements->"Text"],
Cell[5963, 225, 116, 3, 31, 35, 0, "StyleData", "Text", "Printout"]
}, Closed]],

Cell[CellGroupData[{
Cell[6116, 233, 128, 4, 35, 26, 0, "StyleData", "Caption", "All"],
Cell[6247, 239, 53, 1, 33, 38, 0, "StyleData", "Caption", "Printout"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[6349, 246, 42, 0, 30, "Section"],
Cell[6394, 248, 248, 5, 62, "Text"],

Cell[CellGroupData[{
Cell[6667, 257, 534, 16, 56, 24, 0, "StyleData", "Input", "All",
  CounterIncrements->"Input"],
Cell[7204, 275, 112, 3, 53, 36, 0, "StyleData", "Input", "Printout"]
}, Closed]],
Cell[7331, 281, 375, 12, 45, 30, 0, "StyleData", "InlineInput", "All",
  CounterIncrements->"Input"],

Cell[CellGroupData[{
Cell[7731, 297, 521, 15, 55, 25, 0, "StyleData", "Output", "All",
  CounterIncrements->"Output"],
Cell[8255, 314, 113, 3, 54, 37, 0, "StyleData", "Output", "Printout"]
}, Closed]],

Cell[CellGroupData[{
Cell[8405, 322, 523, 16, 59, 28, 0, "StyleData", "InputOnly", "All",
  CounterIncrements->"Input"],
Cell[8931, 340, 116, 3, 54, 40, 0, "StyleData", "InputOnly", "Printout"]
}, Closed]],

Cell[CellGroupData[{
Cell[9084, 348, 574, 18, 40, 26, 0, "StyleData", "Message", "All",
  CounterIncrements->"Message",
  StyleMenuListing->None],
Cell[9661, 368, 88, 2, 24, 38, 0, "StyleData", "Message", "Printout"]
}, Closed]],

Cell[CellGroupData[{
Cell[9786, 375, 533, 16, 57, 24, 0, "StyleData", "Print", "All",
  CounterIncrements->"Print",
  StyleMenuListing->None],
Cell[10322, 393, 87, 2, 51, 36, 0, "StyleData", "Print", "Printout"]
}, Closed]],

Cell[CellGroupData[{
Cell[10446, 400, 483, 14, 56, 27, 0, "StyleData", "Graphics", "All",
  CounterIncrements->"Graphics",
  StyleMenuListing->None],
Cell[10932, 416, 105, 2, 44, 39, 0, "StyleData", "Graphics", "Printout"]
}, Closed]],

Cell[CellGroupData[{
Cell[11074, 423, 120, 4, 43, 28, 0, "StyleData", "CellLabel", "All",
  StyleMenuListing->None],
Cell[11197, 429, 112, 2, 32, 40, 0, "StyleData", "CellLabel", "Printout"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[11358, 437, 32, 0, 30, "Section"],

Cell[CellGroupData[{
Cell[11415, 441, 275, 7, 52, 25, 0, "StyleData", "Author", "All",
  CounterAssignments->{{"Section", 0}, {"Equation", 0}, {"Figure", 0}}],
Cell[11693, 450, 96, 2, 61, 37, 0, "StyleData", "Author", "Printout"]
}, Closed]],

Cell[CellGroupData[{
Cell[11826, 457, 282, 7, 35, 26, 0, "StyleData", "Address", "All",
  CounterAssignments->{{"Section", 0}, {"Equation", 0}, {"Figure", 0}}],
Cell[12111, 466, 96, 2, 30, 38, 0, "StyleData", "Address", "Printout"]
}, Closed]],

Cell[CellGroupData[{
Cell[12244, 473, 114, 3, 36, 27, 0, "StyleData", "Abstract", "All"],
Cell[12361, 478, 99, 2, 81, 39, 0, "StyleData", "Abstract", "Printout"]
}, Closed]],

Cell[CellGroupData[{
Cell[12497, 485, 118, 3, 36, 28, 0, "StyleData", "Reference", "All"],
Cell[12618, 490, 55, 1, 28, 40, 0, "StyleData", "Reference", "Printout"]
}, Closed]],

Cell[CellGroupData[{
Cell[12710, 496, 373, 10, 48, 31, 0, "StyleData", "PictureGroup", "All",
  CounterIncrements->"Graphics",
  StyleMenuListing->None],
Cell[13086, 508, 116, 2, 44, 43, 0, "StyleData", "PictureGroup", "Printout"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[13251, 516, 49, 0, 30, "Section"],
Cell[13303, 518, 225, 4, 62, "Text"],

Cell[CellGroupData[{
Cell[13553, 526, 395, 8, 40, 35, 0, "StyleData", "NumberedEquation", "All",
  CounterIncrements->"NumberedEquation"],
Cell[13951, 536, 252, 4, 40, 47, 0, "StyleData", "NumberedEquation", 
"Printout"]
}, Closed]],

Cell[CellGroupData[{
Cell[14240, 545, 369, 8, 61, 33, 0, "StyleData", "NumberedFigure", "All",
  CounterIncrements->"NumberedFigure"],
Cell[14612, 555, 249, 4, 56, 45, 0, "StyleData", "NumberedFigure", "Printout"]

}, Closed]],

Cell[CellGroupData[{
Cell[14898, 564, 367, 8, 61, 32, 0, "StyleData", "NumberedTable", "All",
  CounterIncrements->"NumberedTable"],
Cell[15268, 574, 246, 4, 56, 44, 0, "StyleData", "NumberedTable", "Printout"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[15563, 584, 43, 0, 30, "Section"],

Cell[CellGroupData[{
Cell[15631, 588, 250, 6, 40, 33, 0, "StyleData", "DisplayFormula", "All"],
Cell[15884, 596, 61, 1, 36, 45, 0, "StyleData", "DisplayFormula", "Printout"]
}, Closed]],

Cell[CellGroupData[{
Cell[15982, 602, 251, 7, 34, 34, 0, "StyleData", "ChemicalFormula", "All"],
Cell[16236, 611, 62, 1, 39, 46, 0, "StyleData", "ChemicalFormula", "Printout"]

}, Closed]],

Cell[CellGroupData[{
Cell[16335, 617, 94, 2, 36, 26, 0, "StyleData", "Program", "All"],
Cell[16432, 621, 98, 2, 35, 38, 0, "StyleData", "Program", "Printout"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[16579, 629, 49, 0, 30, "Section"],
Cell[16631, 631, 93, 3, 34, 25, 0, "StyleData", "Header", "All",
  StyleMenuListing->None],
Cell[16727, 636, 119, 4, 36, 29, 0, "StyleData", "PageNumber", "All",
  StyleMenuListing->None],
Cell[16849, 642, 93, 3, 31, 25, 0, "StyleData", "Footer", "All",
  StyleMenuListing->None]
}, Closed]]
}, Open  ]]
}
]
*)




(***********************************************************************
End of Mathematica Notebook file.
***********************************************************************)

